//
//  MPPopoverView.h
//  TestButton
//
//  Created by Oleksii Dykan on 10/15/14.
//  Copyright (c) 2014 ViolentOctopus. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef NS_ENUM(NSUInteger, MPPopoverArrowPosition) {
    MPPopoverArrowPositionBottom,
    MPPopoverArrowPositionLeft,
    MPPopoverArrowPositionTop,
    MPPopoverArrowPositionRight,
    MPPopoverArrowPositionBottomLeft,
    MPPopoverArrowPositionBottomRight,
    MPPopoverArrowPositionNone
};

@interface MPPopoverView : NSView

@property (nonatomic, copy) IBInspectable NSString *arrowImageName;
@property (nonatomic, copy) IBInspectable NSString *ninePartBackgroundImageName;
@property (nonatomic, assign) IBInspectable NSInteger arrowPosition;
@property (nonatomic, assign) IBInspectable CGPoint arrowOffset;

@property (nonatomic, assign) IBInspectable BOOL blurBackground;

- (void)commonInit;

+ (MPPopoverArrowPosition)defaultArrowPosition;
+ (void)setDefaultArrowPosition:(MPPopoverArrowPosition)defaultArrowPosition;

+ (NSString *)defaultNinePartBackgroundImageName;
+ (void)setDefaultNinePartBackgroundImageName:(NSString *)defaultNinePartBackgroundImageName;

+ (NSString *)defaultArrowImageName;
+ (void)setDefaultArrowImageName:(NSString *)defaultArrowImageName;

+ (CGPoint)defaultArrowOffset;
+ (void)setDefaultArrowOffset:(CGPoint)defaultArrowOffset;

@end
